############### ###############
## 09 - Creating simulated treatment assignment
## Project: CBO
## Author: Kamil Kouhen
## Purpose: For blinded analysis: simulating treatment assignment
## Date of creation: 04/05/2022
############### ###############

library(here) #Always needed
set.seed(seed) #Defined in master file

##Loading master file
#source(here("Code","Rcode", "Master.R"), echo = T) #Master file for file paths

## No need to be run if working with unblinded data ##

if (datatype == "Data/Blinded"){

  ##Simulating treatment assignment on raw CBO-level data
  
  #Simulating treatment commune
  communeTassign <- CBO_groups_raw %>% 
    distinct(commune)
  communeTassign$treatmentcommune <- as.factor(complete_ra(N = length(communeTassign$commune), prob = 0.5))
  
  CBO_groups_raw2 <- left_join(CBO_groups_raw, communeTassign)
  rm(communeTassign)
  
  set.seed(seed) 
  
  #Simulating treated CBOs within treatment communes
  CBOTassign <- CBO_groups_raw2 %>% 
    dplyr::filter(treatmentcommune == 1) %>%
    distinct(appcode)
  CBOTassign$treatment <- as.factor(complete_ra(N = length(CBOTassign$appcode), prob = 0.5))
  
  CBO_groups_raw2 <- left_join(CBO_groups_raw2, CBOTassign, by="appcode") %>%
    mutate(treatment = as.factor(as.character(ifelse(is.na(treatment), 0, as.character(treatment)))))
  rm(CBOTassign)
  
  if (("treatment" %in% names(CBO_groups_final)) == FALSE) { #To avoid merging twice if code already run
    CBO_groups_final <- left_join((CBO_groups_final %>% 
                                      mutate(appcode = as.character(appcode))), #Adding simulated treatment assignment variables to cleaned data
                                   (CBO_groups_raw2 %>% 
                                      dplyr::select(appcode, treatmentcommune, treatment)),
                                   by = "appcode")
  }
  
  #Adding simulated treatment assignment variables to individual level datasets too
  if (("treatment" %in% names(CBO_individuals_final)) == FALSE) { #To avoid merging twice if code already run
    CBO_individuals_final <- left_join((CBO_individuals_final), #Adding simulated treatment assignment variables to cleaned data
                                          (CBO_groups_raw2 %>% 
                                             dplyr::select(appcode, treatmentcommune, treatment)),
                                          by = "appcode")
  }
  
  if (("treatment" %in% names(CBO_groups_final_IND)) == FALSE) { #To avoid merging twice if code already run
    CBO_groups_final_IND <- left_join((CBO_groups_final_IND), #Adding simulated treatment assignment variables to cleaned data
                                      (CBO_groups_raw2 %>% 
                                         dplyr::select(appcode, treatmentcommune, treatment)),
                                      by = "appcode")
  }
  
  
  #Adding simulated treatment assignment variables to DM level datasets too
  if (length(setdiff(unique(DM_final$commune), unique(CBO_groups_raw2$commune))) != 0) stop("Not all municipalities were matched. Please fix this before proceeding to the merging.")
  
  if (("treatmentcommune" %in% names(DM_final)) == FALSE) { #To avoid merging twice if code already run
    DM_final <- left_join((DM_final %>% 
                              mutate(commune = as.character(commune))), 
                           (CBO_groups_raw2 %>% 
                              mutate(commune = as.character(commune)) %>%
                              distinct(commune, .keep_all = T) %>% 
                              dplyr::select(commune, treatmentcommune)),
                           by = "commune")
  }
  
  DM_final$region_commune <- paste(DM_final$region, DM_final$commune, sep="_")
  DM_final$treatmentcommune <- as.numeric(DM_final$treatmentcommune==1)
  
  
  if (("treatmentcommune" %in% names(DM_finalx2)) == FALSE) { #To avoid merging twice if code already run
    DM_finalx2 <- left_join((DM_finalx2 %>% #Dataset where each observation is DM/CBO combination
                                mutate(commune = as.character(commune))), 
                             (CBO_groups_raw2 %>% 
                                mutate(commune = as.character(commune)) %>%
                                distinct(commune, .keep_all = T) %>% 
                                dplyr::select(commune, treatmentcommune)),
                             by = "commune")
  }
  
  DM_finalx2$region_commune <- paste(DM_finalx2$region, DM_finalx2$commune, sep="_")
  DM_finalx2$treatmentcommune <- as.numeric(DM_finalx2$treatmentcommune==1)
  

  rm(CBO_groups_raw2)
  
  
  ##Saving blinded datasets with simulated treatment assignment
  sapply(c("CBO_groups_final",
           "CBO_individuals_final",
           "CBO_groups_final_IND",
           "DM_final",
           "DM_finalx2"), 
         function(ds)
           eval(parse(text = paste0("saveRDS(", ds,", file = here(datatype, 'Final', '", ds, ".RDS'))"
           ))))
}

message("**07 completed")

